set echo on
connect internal/oracle@pcmag

ALTER DATABASE DATAFILE 'F:\Oracle\Oradata\PCMag\system01.dbf' AUTOEXTEND ON;
CREATE ROLLBACK SEGMENT SYSROL TABLESPACE "SYSTEM" STORAGE (INITIAL 10M NEXT 10M);
ALTER ROLLBACK SEGMENT "SYSROL" ONLINE;

REM ********** TABLESPACE FOR ROLLBACK **********
CREATE TABLESPACE RBS DATAFILE 'F:\Oracle\Oradata\PCMag\rbs01.dbf' SIZE 1000M REUSE
DEFAULT STORAGE ( INITIAL 1M NEXT 1M MINEXTENTS 2 MAXEXTENTS UNLIMITED PCTINCREASE 10);
ALTER DATABASE DATAFILE 'F:\Oracle\Oradata\PCMag\rbs01.dbf' AUTOEXTEND ON;

REM ********** ALTER SYSTEM TABLESPACE *********
ALTER TABLESPACE SYSTEM
DEFAULT STORAGE ( INITIAL 1M NEXT 1M MINEXTENTS 1 PCTINCREASE 10);

REM ********** TABLESPACE FOR USER **********
CREATE TABLESPACE USERS DATAFILE 'F:\Oracle\Oradata\PCMag\users01.dbf' SIZE 6000M REUSE
DEFAULT STORAGE ( INITIAL 50K NEXT 50K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 10);
ALTER DATABASE DATAFILE 'F:\Oracle\Oradata\PCMag\users01.dbf' AUTOEXTEND ON;

REM ********** TABLESPACE FOR TEMPORARY **********
CREATE TABLESPACE TEMP DATAFILE 'F:\Oracle\Oradata\PCMag\temp01.dbf' SIZE 10M REUSE
DEFAULT STORAGE ( INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 10) TEMPORARY;
ALTER DATABASE DATAFILE 'F:\Oracle\Oradata\PCMag\temp01.dbf' AUTOEXTEND ON;

REM ********** TABLESPACE FOR INDEX **********
CREATE TABLESPACE INDX DATAFILE 'F:\Oracle\Oradata\PCMag\indx01.dbf' SIZE 3000M REUSE
DEFAULT STORAGE ( INITIAL 1M NEXT 1M MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 10);
ALTER DATABASE DATAFILE 'F:\Oracle\Oradata\PCMag\indx01.dbf' AUTOEXTEND ON;

REM ********** TABLESPACE FOR OEM_REPOSITORY **********
CREATE TABLESPACE OEM_REPOSITORY DATAFILE 'F:\Oracle\Oradata\PCMag\oemrep01.dbf' SIZE 5M REUSE
AUTOEXTEND ON NEXT 25M MAXSIZE 80M
MINIMUM EXTENT 128K
DEFAULT STORAGE ( INITIAL 128K NEXT 128K MINEXTENTS 1 MAXEXTENTS UNLIMITED PCTINCREASE 0);

REM ********** CREATE ROLLBACK SEGMENTS **********
CREATE PUBLIC ROLLBACK SEGMENT RB01 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB02 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB03 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB04 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB05 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB06 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB07 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB08 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB09 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB10 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB11 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB12 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB13 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB14 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB15 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB16 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB17 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB18 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB19 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB20 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB21 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB22 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB23 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB24 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB25 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB26 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB27 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB28 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB29 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB30 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB31 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB32 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB33 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB34 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB35 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB36 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB37 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB38 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB39 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB40 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB41 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB42 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB43 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB44 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB45 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB46 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB47 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB48 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB49 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
CREATE PUBLIC ROLLBACK SEGMENT RB50 TABLESPACE RBS
STORAGE (INITIAL 10M NEXT 1M);
ALTER ROLLBACK SEGMENT "RB01" ONLINE;
ALTER ROLLBACK SEGMENT "RB02" ONLINE;
ALTER ROLLBACK SEGMENT "RB03" ONLINE;
ALTER ROLLBACK SEGMENT "RB04" ONLINE;
ALTER ROLLBACK SEGMENT "RB05" ONLINE;
ALTER ROLLBACK SEGMENT "RB06" ONLINE;
ALTER ROLLBACK SEGMENT "RB07" ONLINE;
ALTER ROLLBACK SEGMENT "RB08" ONLINE;
ALTER ROLLBACK SEGMENT "RB09" ONLINE;
ALTER ROLLBACK SEGMENT "RB10" ONLINE;
ALTER ROLLBACK SEGMENT "RB11" ONLINE;
ALTER ROLLBACK SEGMENT "RB12" ONLINE;
ALTER ROLLBACK SEGMENT "RB13" ONLINE;
ALTER ROLLBACK SEGMENT "RB14" ONLINE;
ALTER ROLLBACK SEGMENT "RB15" ONLINE;
ALTER ROLLBACK SEGMENT "RB16" ONLINE;
ALTER ROLLBACK SEGMENT "RB17" ONLINE;
ALTER ROLLBACK SEGMENT "RB18" ONLINE;
ALTER ROLLBACK SEGMENT "RB19" ONLINE;
ALTER ROLLBACK SEGMENT "RB20" ONLINE;
ALTER ROLLBACK SEGMENT "RB21" ONLINE;
ALTER ROLLBACK SEGMENT "RB22" ONLINE;
ALTER ROLLBACK SEGMENT "RB23" ONLINE;
ALTER ROLLBACK SEGMENT "RB24" ONLINE;
ALTER ROLLBACK SEGMENT "RB25" ONLINE;
ALTER ROLLBACK SEGMENT "RB26" ONLINE;
ALTER ROLLBACK SEGMENT "RB27" ONLINE;
ALTER ROLLBACK SEGMENT "RB28" ONLINE;
ALTER ROLLBACK SEGMENT "RB29" ONLINE;
ALTER ROLLBACK SEGMENT "RB30" ONLINE;
ALTER ROLLBACK SEGMENT "RB31" ONLINE;
ALTER ROLLBACK SEGMENT "RB32" ONLINE;
ALTER ROLLBACK SEGMENT "RB33" ONLINE;
ALTER ROLLBACK SEGMENT "RB34" ONLINE;
ALTER ROLLBACK SEGMENT "RB35" ONLINE;
ALTER ROLLBACK SEGMENT "RB36" ONLINE;
ALTER ROLLBACK SEGMENT "RB37" ONLINE;
ALTER ROLLBACK SEGMENT "RB38" ONLINE;
ALTER ROLLBACK SEGMENT "RB39" ONLINE;
ALTER ROLLBACK SEGMENT "RB40" ONLINE;
ALTER ROLLBACK SEGMENT "RB41" ONLINE;
ALTER ROLLBACK SEGMENT "RB42" ONLINE;
ALTER ROLLBACK SEGMENT "RB43" ONLINE;
ALTER ROLLBACK SEGMENT "RB44" ONLINE;
ALTER ROLLBACK SEGMENT "RB45" ONLINE;
ALTER ROLLBACK SEGMENT "RB46" ONLINE;
ALTER ROLLBACK SEGMENT "RB47" ONLINE;
ALTER ROLLBACK SEGMENT "RB48" ONLINE;
ALTER ROLLBACK SEGMENT "RB49" ONLINE;
ALTER ROLLBACK SEGMENT "RB50" ONLINE;

REM setup database
alter user sys temporary tablespace TEMP;

REM create catalog tables
@C:\Oracle\Ora81\Rdbms\admin\catalog.sql;
@C:\Oracle\Ora81\Rdbms\admin\catexp7.sql
@C:\Oracle\Ora81\Rdbms\admin\catproc.sql
@C:\Oracle\Ora81\Rdbms\admin\caths.sql
connect system/manager@pcmag
@C:\Oracle\Ora81\dbs\pupbld.sql

REM create standard scott and demo schemas
connect internal/oracle@pcmag
@C:\Oracle\Ora81\Rdbms\admin\scott.sql
connect internal/oracle@pcmag
@C:\Oracle\Ora81\Rdbms\admin\demo.sql

connect internal/oracle@pcmag
alter rollback segment "SYSROL" offline;

exit
